﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;   
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VHAReportViewer;

public partial class PatientHealthFactors : BasePage
{
    private ReportViewerHandler _reportViewerHandler;

    public override string TopMenuName()
    {
        return "My Tasks";
    }
    public override string MenuItemName()
    {
        return "TBI NOTICES";
    }
    public override string AppObjectCode()
    {
        return "TBI NOTICES";
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;

            


            TBI_REFERRAL referral;
            TBIReferralManager referralManager = new TBIReferralManager();
            int _referralId;
            string _facilityId;
            string _ssn;
            if (int.TryParse(Request.QueryString["id"], out _referralId))
            {
                referral = referralManager.SelectByID(_referralId);
                _ssn = referral.PATIENT.Snum;

                //_facilityId = referral.PATIENT.STD_INSTITUTION_ID.ToString();
                _facilityId = referral.STD_INSTITUTION.STATIONNUMBER.ToString();   
                HiddenFieldReferralID.Value = _referralId.ToString();

                LabelBreadCrumb.Text = "My Tasks > Referrals > Health Factors" + " > View Report For Patient: " + HiddenFieldReferralID.Value;  
            }   
            else
            {
                _ssn = "";
                _facilityId = "";
            }
            

            ViewState["ReportViewerHandler"] = _reportViewerHandler = new ReportViewerHandler();

            //_reportViewerHandler.AddReportVariable("VeteranSSN", this.SSNAndFacilitySelect1.SSN);
            //_reportViewerHandler.SetReportParameters(ReportViewer1);
            //_reportViewerHandler.SetServerReportParameters(ReportViewer1);

            //ReportViewer1.Visible = true;

            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

            ReportViewer1.Reset();

            ReportViewer1.ServerReport.ReportPath = "VeteransScreeningQuestions";

            //var config = RegistriesConfigurations.GetConfig();

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            // _reportViewerHandler.AddReportVariable("TableTitle", ReportLevel1.TableTitle);
            _reportViewerHandler.AddReportVariable("VeteranSSN", _ssn);
            _reportViewerHandler.AddReportVariable("Username", _currentUser1.FullName);
            _reportViewerHandler.AddReportVariable("FacilityId", _facilityId);

            //_reportViewerHandler.SetReportParameters(ReportViewer1);
            _reportViewerHandler.SetServerReportParameters(ReportViewer1);

            ReportViewer1.Visible = true;

            //ReportViewer1.ServerReport.DisplayName = "What";

            ReportViewer1.ProcessingMode = ProcessingMode.Remote;

            ReportViewer1.Visible = true;
            ReportViewer1.ServerReport.Refresh(); 
        }
        else
        {
            _reportViewerHandler = (ReportViewerHandler)ViewState["ReportViewerHandler"];
        }

        
   }
    protected void ObjectDataSourcePatientHealthFactors_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["referralId"] = int.Parse(Page.Request.QueryString["id"]);
    }

    //protected void SqlDataSourceSection1_Selecting(object sender, SqlDataSourceSelectingEventArgs e)
    //{
    //    if (!string.IsNullOrEmpty(Page.Request.QueryString["id"]))
    //    {
    //        e.Command.Parameters["@referralId"].Value = int.Parse(Page.Request.QueryString["id"]);
    //    }
    //}
}
